
// IntelEncoderDlg.cpp : implementation file
//

#include "stdafx.h"
#include "IntelEncoder.h"
#include "IntelEncoderDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BYTE * g_p_video_frame_buffer_background = NULL;

ULONG  g_n_video_frame_length_background = 0;

ULONGLONG g_n_src_video_sample_time = 0;

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[DEBUG] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

DWORD WINAPI on_push_video_framebuffer( LPVOID params )
{
	CIntelEncoderDlg *  pMainDialog = (CIntelEncoderDlg *)(params);

	while ( TRUE && pMainDialog->m_bSetBuffer )
    {
		DWORD dwWaitResult = 0x00000000;

		dwWaitResult = WaitForSingleObject( pMainDialog->m_hVideoThreadBufferReadyEvent, INFINITE );		

		if( dwWaitResult == WAIT_OBJECT_0 )
		{
			if ( g_p_video_frame_buffer_background != NULL && g_n_video_frame_length_background > 0 )
			{
				BOOL bIsRecord = (pMainDialog->m_nFileRendererRecordState >= 0x00000002) ? TRUE : FALSE;

				if ( pMainDialog->m_hVideoIntelEncoderDev != 0xFFFFFFFF )
				{
					BYTE * pStreamBuffer = NULL;

					ULONG  nStreamBufferLen = 0;

					BOOL   bIsKeyFrame = FALSE;

					ULONGLONG nDstPresentationTimeStamp = 0;

					ULONGLONG nDstDecodeTimeStamp = 0;

					AMESDK_RUN( pMainDialog->m_hVideoSwEncoderDev ); // PUT THE ENCODER INTO RUNNING STATE

					AMESDK_CODEC_ENCODE( pMainDialog->m_hVideoSwEncoderDev, g_p_video_frame_buffer_background, PREVIEW_COLORSPACE,  WIDTH, HEIGHT, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, FALSE,  g_n_src_video_sample_time, &nDstPresentationTimeStamp, &nDstDecodeTimeStamp );	

					if( bIsKeyFrame ) 
					{ 
						pMainDialog->m_nFileRendererRecordState = 0x00000002;

						bIsRecord = TRUE;
					}

					if( bIsRecord && nStreamBufferLen > 0 ) 
					{
						if ( pMainDialog->m_pBinFile != NULL )
						{
							pMainDialog->m_pBinFile->Write( pStreamBuffer, nStreamBufferLen );
						}

						if ( pMainDialog->m_pTxtFile != NULL )
						{
							CString strTxt;

							strTxt.Format( "%d,%I64d,%d\n", nStreamBufferLen, nDstDecodeTimeStamp, ( bIsKeyFrame ) ? 1: 0 );

							pMainDialog->m_pTxtFile->WriteString( strTxt );
						}					
					}
				}
			}
		}
	}

	return 0;
}

BOOL on_process_preview_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CIntelEncoderDlg *  pMainDialog = (CIntelEncoderDlg *)(pUserData);
	
	if ( pBuffer != NULL && nBufferLen > 0 )
	{
		g_p_video_frame_buffer_background = pBuffer;

		g_n_video_frame_length_background = nBufferLen;		

		g_n_src_video_sample_time = (ULONGLONG)(dSampleTime * 10000000);
		
		if(  pMainDialog->m_hVideoThreadBufferReadyEvent )
		{
			SetEvent( pMainDialog->m_hVideoThreadBufferReadyEvent );
		}		
	}

	return TRUE;
}

// CIntelEncoderDlg dialog


CIntelEncoderDlg::CIntelEncoderDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CIntelEncoderDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev = 0xFFFFFFFF;		
	
	m_hVideoIntelEncoderDev = 0xFFFFFFFF;

	m_nFileRendererRecordState = 0x00000000;

	m_hVideoThreadBufferReadyEvent = NULL;

	m_hVideoThread = NULL;	

	m_hVideoThreadNumber = 0;

	m_bSetBuffer = FALSE;

	m_pTxtFile = NULL;

	m_pBinFile = NULL;
}

void CIntelEncoderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIntelEncoderDlg)
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_BTN_START, m_btnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	//}}AFX_DATA_MAP	
}

BEGIN_MESSAGE_MAP(CIntelEncoderDlg, CDialogEx)
	//{{AFX_MSG_MAP(CIntelEncoderDlg)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_START, &CIntelEncoderDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CIntelEncoderDlg::OnBnClickedBtnStop)
END_MESSAGE_MAP()


// CIntelEncoderDlg message handlers

BOOL CIntelEncoderDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	CenterWindow();

	CString strCaption;

	strCaption.Format( "Yuan's %s Demo Software - H.264 Intel Encoder", PRODUCT_NAME );

	SetWindowText( strCaption );

	InitializeCriticalSection( &m_hAccessFileCriticalSection );

	HwInitialize();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIntelEncoderDlg::OnDestroy() 
{
	OnBnClickedBtnStop();

	HwUnInitialize();

	DeleteCriticalSection( &m_hAccessFileCriticalSection );

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

BOOL CIntelEncoderDlg::HwInitialize()
{
	PF_BUFFER_CALLBACK pfVideoPreviewBC = NULL;

	pfVideoPreviewBC = on_process_preview_video_buffer;

	CWnd *pPreviewWnd = GetDlgItem( IDC_STATIC_WINDOW );

	m_hVideoDev = AMESDK_CREATE_EX( CHIP_NAME, 0, 0,  pPreviewWnd->GetSafeHwnd(), pfVideoPreviewBC, FALSE, TRUE, TRUE, this );			

	if( m_hVideoDev & 0x80000000 ) 
	{ 
		m_hVideoDev = 0xFFFFFFFF; 

		return FALSE; 		
	}

	// SETUP LIVE PATH PROPERTIES
	// 		
	AMESDK_SET_STANDARD( m_hVideoDev, NTSC );
	
	AMESDK_SET_FORMAT( m_hVideoDev, PREVIEW_COLORSPACE, WIDTH, HEIGHT, PREVIEW_BIT_COUNT, FPS );

	AMESDK_SET_INPUT( m_hVideoDev, SDI_INPUT );

	m_hVideoIntelEncoderDev = AMESDK_CREATE( "Common Analog Intel Encoder (H.264)", 0, 7, NULL, NULL, NULL );
		
	if( m_hVideoIntelEncoderDev & 0x80000000 ) 
	{ 
		m_hVideoIntelEncoderDev = 0xFFFFFFFF; 

		return FALSE; 	
	}

	// SETUP SOFTWARE ENCODER PROPERTIES
	//
	AMESDK_SET_FORMAT( m_hVideoIntelEncoderDev, ENCODER_COLORSPACE, WIDTH, HEIGHT, ENCODER_BIT_COUNT, FPS, ENCODER_MODE, ENCODER_BITRATE, ENCODER_QUALITY, ENCODER_GOP,  FALSE, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

	AMESDK_RUN( m_hVideoDev );

	AMESDK_RUN( m_hVideoIntelEncoderDev );

	m_hVideoThreadBufferReadyEvent = CreateEvent( NULL, FALSE, FALSE, NULL );		

	m_bSetBuffer = TRUE;

	m_hVideoThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)( on_push_video_framebuffer ), (LPVOID)(this), 0, &m_hVideoThreadNumber );	

	return TRUE;
}

BOOL CIntelEncoderDlg::HwUnInitialize()
{
	m_bSetBuffer = FALSE;

	Sleep( 100 );

	if ( m_hVideoThreadBufferReadyEvent )
	{
		ResetEvent( m_hVideoThreadBufferReadyEvent );

		CloseHandle( m_hVideoThreadBufferReadyEvent );	

		m_hVideoThreadBufferReadyEvent = NULL;
	}

	if( m_hVideoDev != 0xFFFFFFFF ) 
	{ 
		AMESDK_STOP( m_hVideoDev );

		AMESDK_DESTROY( m_hVideoDev );
		
		m_hVideoDev = 0xFFFFFFFF; 
	}

	if( m_hVideoIntelEncoderDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hVideoIntelEncoderDev );
		
		m_hVideoIntelEncoderDev = 0xFFFFFFFF; 
	}		

	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CIntelEncoderDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CIntelEncoderDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CString CIntelEncoderDlg::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}

void CIntelEncoderDlg::OnBnClickedBtnStart()
{
	// TODO: Add your control notification handler code here

	m_btnStart.EnableWindow( FALSE );

	m_btnStop.EnableWindow( TRUE );

	m_pTxtFile = NULL;

	m_pBinFile = NULL;

	CHAR pszTxtFile[ MAX_PATH ];

	CHAR pszBinFile[ MAX_PATH ];

	sprintf( pszTxtFile, "%sINTEL_H264_%d_%d_%.2f.TXT", GetWorkingPath(), WIDTH, HEIGHT, FPS );

	sprintf( pszBinFile, "%sINTEL_H264_%d_%d_%.2f.H264", GetWorkingPath(), WIDTH, HEIGHT, FPS );

	m_pTxtFile = new CStdioFile( pszTxtFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeText );	

	m_pBinFile = new CStdioFile( pszBinFile,  CFile::modeCreate | CFile::modeWrite | CFile::typeBinary );

	m_nFileRendererRecordState = 0x00000001;
}


void CIntelEncoderDlg::OnBnClickedBtnStop()
{
	// TODO: Add your control notification handler code here

	m_nFileRendererRecordState= 0x00000000;

	Sleep( 100 );

	m_btnStart.EnableWindow( TRUE );

	m_btnStop.EnableWindow( FALSE );

	if ( m_pTxtFile != NULL )
	{
		m_pTxtFile->Close();

		delete m_pTxtFile;

		m_pTxtFile = NULL;
	}

	if ( m_pBinFile != NULL )
	{
		m_pBinFile->Close();

		delete m_pBinFile;

		m_pBinFile = NULL;
	}
}
